/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;

public record IntegerBounds(int min, int max) {
    public static final Codec<IntegerBounds> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)-2147483647).forGetter(bounds -> bounds.min), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(bounds -> bounds.max)).apply((Applicative)instance, IntegerBounds::new));
    public static IntegerBounds NONE = new IntegerBounds(-2147483647, Integer.MAX_VALUE);

    public boolean test(int value) {
        return value >= this.min && value <= this.max;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("min", this.min);
        tag.m_128405_("max", this.max);
        return tag;
    }

    public static IntegerBounds deserialize(CompoundTag tag) {
        return new IntegerBounds(tag.m_128451_("min"), tag.m_128451_("max"));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerBounds that = (IntegerBounds)obj;
        if (!Objects.equals(this.min, that.min)) {
            return false;
        }
        return Objects.equals(this.max, that.max);
    }
}

